//
//  GSHandle.h
//  GlyphsCore
//
//  Created by Georg Seifert on 22.09.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSElement.h>
#import <GlyphsCore/GSSelectableElementProtocol.h>

typedef NS_ENUM(NSInteger, GSSpecialHintFlags) {
	GSIntersectionFlag = 1000,
	GSLSBFlag = 1001,
	GSRSBFlag = 1002,
	GSInflectionFlag = 1003,
	GSStrokeOut = 1004,
	GSStrokeIn = 1005,
};

@interface GSHandle : NSObject <GSSelectableElementProtocol>

@property (nonatomic, assign) int flag;
@property (nonatomic, strong) NSCursor *cursor;
@property (nonatomic, strong) id object;
@property (nonatomic, assign) NSPoint position;

@property (nonatomic, readonly) BOOL canAttachHint;
@property (nonatomic, readonly) BOOL canAttachCorner;

@end
